<?php $__env->startSection('page_title', __('Label.Add_Notification')); ?>

<?php $__env->startSection('content'); ?>
	<?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<div class="right-content">
		<?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm"><?php echo e(__('Label.Add_Notification')); ?></h1>

			<div class="border-bottom row">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a></li>
						<li class="breadcrumb-item"><a href="<?php echo e(route('notification.index')); ?>"><?php echo e(__('Label.Notification')); ?></a></li>
						<li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Label.Add_Notification')); ?></li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center justify-content-end">
					<a href="<?php echo e(route('notification.index')); ?>" class="btn btn-default mw-120" style="margin-top:-14px"><?php echo e(__('Label.Notification_List')); ?></a>
				</div>
			</div>

			<div class="card custom-border-card mt-3">
				<form id="notification" enctype="multipart/form-data">
					<input type="hidden" name="id" value="">
					<div class="form-row">
						<div class="col-md-8">
							<div class="form-row">
								<div class="col-md-12">
									<div class="form-group">
										<label><?php echo e(__('Label.Title')); ?></label>
										<input name="title" type="text" class="form-control" placeholder="Enter Title" autofocus>
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-12">
									<div class="form-group">
										<label><?php echo e(__('Label.Message')); ?></label>
										<textarea class="form-control" rows="5" name="message" placeholder="<?php echo e(__('Label.Start Write Here...')); ?>"></textarea>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-3 ml-5">
							<div class="form-group ">
								<label class="">Image<span class="text-danger">*</span></label>
								<div class="avatar-upload ">
									<div class="avatar-edit">
										<input type='file' name="image" id="imageUpload" accept=".png, .jpg, .jpeg" />
										<label for="imageUpload" title="Select File"></label>
									</div>
									<div class="avatar-preview">
										<img src="<?php echo e(asset('assets/imgs/upload_img.png')); ?>" alt="upload_img.png" id="imagePreview">
									</div>
								</div>
								<label class="mt-3  text-gray">Maximum size 2MB.</label>
							</div>
						</div>
					</div>
					<div class="border-top pt-3 text-right">
						<button type="button" class="btn btn-default mw-120" onclick="save_notification()"><?php echo e(__('Label.SAVE')); ?></button>
						<a href="<?php echo e(route('notification.index')); ?>" class="btn btn-cancel mw-120 ml-2"><?php echo e(__('Label.CANCEL')); ?></a>
						<input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
					</div>
				</form>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
	<script>

        // Sidebar Scroll Down
        let sidebarHeight = $('.sidebar')[0].scrollHeight;
        sidebar_down(sidebarHeight);

		function save_notification() {
			var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
			if (Check_Admin == 1) {

				$("#dvloader").show();
				var formData = new FormData($("#notification")[0]);
				$.ajax({
					type: 'POST',
					url: '<?php echo e(route("notification.store")); ?>',
					data: formData,
					cache: false,
					contentType: false,
					processData: false,
					success: function(resp) {
						$("#dvloader").hide();
						get_responce_message(resp, 'notification', '<?php echo e(route("notification.index")); ?>');
					},
					error: function(XMLHttpRequest, textStatus, errorThrown) {
						$("#dvloader").hide();
						toastr.error(errorThrown, textStatus);
					}
				});
			} else {
				toastr.error('You have no right to add, edit, and delete.');
			}
		}
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtpocket_fm/resources/views/admin/notification/add.blade.php ENDPATH**/ ?>