<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-6 d-flex flex-column justify-content-center">
            <div class="install-card">

                <!-- Alert MSG -->
                <?php if(session()->has('error')): ?>
                    <div class="alert alert-danger alert-block">
                        <button type="button" class="close" data-dismiss="alert" title="Remove">X</button>
                        <strong><?php echo e(Session::get('error')); ?></strong>
                    </div>
                <?php elseif(session()->has('success')): ?>
                    <div class="alert alert-danger alert-block">
                        <button type="button" class="close" data-dismiss="alert" title="Remove">X</button>
                        <strong><?php echo e(Session::get('success')); ?></strong>
                    </div>
                <?php endif; ?>

                <h1 class="primary-color install-title"><?php echo e(__('Label.purchase_information')); ?></h1>
                <h1 class="install_sub_title mb-2"><?php echo e(__('Label.provide_your_codecanyon_username_&purchase_code')); ?></h1>
                <h6><?php echo e(__('Label.to_find_your_purchase_code_you_can_visit_this_link')); ?>

                    <a href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code" target="_blank"><?php echo e(__('Label.where_is_my_purchase_code')); ?></a>
                </h6>

                <div class="mt-3">
                    <form method="POST" action="<?php echo e(route('purchase_code',['token'=>bcrypt('step_3')])); ?>" onsubmit="showLoder()">
                        <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo e(__('Label.user_name')); ?><span class="text-danger">*</span></label>
                                    <input type="text" name="user_name" value="<?php echo e($user_name); ?>" class="form-control" placeholder="<?php echo e(__('Label.user_name_here')); ?>" autofocus>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo e(__('Label.purchase_code')); ?><span class="text-danger">*</span></label>
                                    <input type="text" name="purchase_code" value="<?php echo e($purchase_code); ?>" class="form-control" placeholder="<?php echo e(__('Label.purchase_code_here')); ?>">
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-install"><?php echo e(__('Label.continue')); ?><i class="fa-solid fa-angles-right ml-2"></i></button>
                    </form>
                </div>

                <?php if(session()->has('result')): ?>
                    <div class="card mt-4">
                        <div class="card-body">
                            <div class="mar-ver pad-btm text-center">
                                <h6><?php echo e(__('Label.this_purchase_code_is_already_registered_to_a_different_domain')); ?></h6>
                                <h5 class="primary-color"><b><?php echo e(session('result')); ?></b></h5>
                            </div>
                            <div class="text-center mt-3">
                                <a href="<?php echo e(route('update_purchase_code')); ?>" class="btn btn-install" onclick="showLoader()"><?php echo e(__('Label.yes')); ?></a>
                                <a href="<?php echo e(route('step2', ['token' => bcrypt('step_2')])); ?>" class="btn btn-install-cancel" onclick="showLoader()"><?php echo e(__('Label.no')); ?></a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Footer -->
                <?php echo $__env->make('installation.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            </div>
        </div>
        <div class="col-lg-6 install-bg-img d-none d-lg-block">
            <img src="<?php echo e(asset('assets/imgs/install_bg.png')); ?>" alt="Software Installation">
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('installation.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtpocket_fm/resources/views/installation/step2.blade.php ENDPATH**/ ?>