
<?php $__env->startSection('page_title', 'App Settings'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="right-content">
        <?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="body-content">
            <!-- mobile title -->
            <h1 class="page-title-sm">App Settings</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page">App Settings</li>
                    </ol>
                </div>
            </div>

            <ul class="nav nav-pills custom-tabs inline-tabs" id="pills-tab" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="app-tab" data-toggle="tab" href="#app" role="tab" aria-controls="app" aria-selected="true"><?php echo e(__('Label.APP SETTINGS')); ?></a>
                </li>
                <?php if( env('DEMO_MODE') == 'OFF'): ?>
                <li class="nav-item">
                    <a class="nav-link" id="smtp-tab" data-toggle="tab" href="#smtp" role="tab" aria-controls="smtp" aria-selected="false">SMTP</a>
                </li>
                <?php endif; ?>
            </ul>

            <div class="tab-content" id="pills-tabContent">
                <div class="tab-pane fade show active" id="app" role="tabpanel" aria-labelledby="app-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header"><?php echo e(__('Label.App Settings')); ?></h5>
                        <div class="card-body">
                            <form id="app_setting" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="form-row">
                                    <div class="col-md-9">
                                        <div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label><?php echo e(__('Label.App Name')); ?><span class="text-danger">*</span></label>
                                                <input type="text" name="app_name" value="<?php if($result && isset($result['app_name'])): ?><?php echo e($result['app_name']); ?><?php endif; ?>" class="form-control" placeholder="Enter App Name" autofocus>
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label><?php echo e(__('Label.Host Email')); ?><span class="text-danger">*</span></label>
                                                <input type="email" name="host_email" value="<?php if($result && isset($result['host_email'])): ?><?php echo e($result['host_email']); ?><?php endif; ?>" class="form-control" placeholder="Enter Host Email">
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label><?php echo e(__('Label.App Version')); ?><span class="text-danger">*</span></label>
                                                <input type="text" name="app_version" value="<?php if($result && isset($result['app_version'])): ?><?php echo e($result['app_version']); ?><?php endif; ?>" class="form-control" placeholder="Enter App Version">
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label><?php echo e(__('Label.Author')); ?><span class="text-danger">*</span></label>
                                                <input type="text" name="author" value="<?php if($result && isset($result['author'])): ?><?php echo e($result['author']); ?><?php endif; ?>" class="form-control" placeholder="Enter Author">
                                            </div>
                                            <div class="form-group col-md-4">
                                                <label><?php echo e(__('Label.Email')); ?> <span class="text-danger">*</span></label>
                                                <input type="email" name="email"  value="<?php if($result && isset($result['email'])): ?><?php echo e($result['email']); ?><?php endif; ?>" class="form-control" placeholder="Enter Email">
                                            </div>
                                            <div class="form-group  col-md-4">
                                                <label> <?php echo e(__('Label.Contact')); ?> <span class="text-danger">*</span></label>
                                                <input type="text" name="contact" value="<?php if($result && isset($result['contact'])): ?><?php echo e($result['contact']); ?><?php endif; ?>" class="form-control" placeholder="Enter Contact">
                                            </div>
                                        </div>
                                        <div class="form-row">
                                            <div class="form-group col-md-4">
                                                <label><?php echo e(__('Label.WEBSITE')); ?><span class="text-danger">*</span></label>
                                                <input type="text" name="website" value="<?php if($result && isset($result['website'])): ?><?php echo e($result['website']); ?><?php endif; ?>" class="form-control" placeholder="Enter Your Website">
                                            </div>
                                            <div class="form-group col-md-8">
                                                <label><?php echo e(__('Label.APP DESCRIPATION')); ?><span class="text-danger">*</span></label>
                                                <textarea name="app_desripation" rows="1" class="form-control" placeholder="Enter App Desripation"><?php if($result && isset($result['app_desripation'])): ?><?php echo e($result['app_desripation']); ?><?php endif; ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group ml-5">
                                            <label class="ml-5">App Icon<span class="text-danger">*</span></label>
                                            <div class="avatar-upload ml-5">
                                                <div class="avatar-edit">
                                                    <input type='file' name="app_logo" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                                    <label for="imageUpload" title="Select File"></label>
                                                </div>
                                                <div class="avatar-preview">
                                                    <img src="<?php echo e($result['app_logo']); ?>" alt="upload_img.png" id="imagePreview">
                                                </div>
                                            </div>
                                            <input type="hidden" name="old_app_logo" value="<?php echo e($result['app_logo']); ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="app_setting()"><?php echo e(__('Label.SAVE')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="col-6">
                            <div class="card custom-border-card">
                                <h5 class="card-header">API Configrations</h5>
                                <div class="card-body">
                                    <div class="input-group">
                                        <div class="col-2">
                                            <label class="pt-3" style="font-size:16px; font-weight:500; color:#1b1b1b"><?php echo e(__('Label.API Path')); ?></label>
                                        </div>
                                        <input type="text" readonly value="<?php echo e(url('/')); ?>/api/" name="api_path" class="form-control" id="api_path">
                                        <div class="input-group-text ml-2" onclick="Function_Api_path()" title="Copy">
                                            <i class="fa-solid fa-copy fa-2xl"></i>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card custom-border-card">
                                <h5 class="card-header"><?php echo e(__('Label.Currency Settings')); ?></h5>
                                <div class="card-body">
                                    <form id="save_currency">
                                        <div class="form-row">
                                            <div class="form-group col-md-6">
                                                <label><?php echo e(__('Label.Currency Name')); ?><span class="text-danger">*</span></label>
                                                <input type="text" name="currency" class="form-control" value="<?php echo e($result['currency']); ?>" placeholder="Enter Currency Name">
                                            </div>
                                            <div class="form-group col-md-6">
                                                <label><?php echo e(__('Label.Currency Code')); ?><span class="text-danger">*</span></label>
                                                <input type="text" name="currency_code" class="form-control" value="<?php echo e($result['currency_code']); ?>" placeholder="Enter Currency Code">
                                            </div>
                                        </div>
                                        <div class="border-top pt-3 text-right">
                                            <button type="button" class="btn btn-default mw-120" onclick="save_currency()"><?php echo e(__('Label.SAVE')); ?></button>
                                            <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="smtp" role="tabpanel" aria-labelledby="smtp-tab">
                    <div class="card custom-border-card">
                        <h5 class="card-header"><?php echo e(__('Label.Email Setting [SMTP]')); ?></h5>
                        <div class="card-body">
                            <form id="smtp_setting">
                                <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                                <input type="hidden" name="id" value="<?php if($smtp): ?><?php echo e($smtp->id); ?><?php endif; ?>">
                                <div class="form-row">
                                    <div class="form-group  col-md-3">
                                        <label><?php echo e(__('Label.IS SMTP Active')); ?><span class="text-danger">*</span></label>
                                        <select name="status" class="form-control">
                                            <option value="">Select Status</option>
                                            <option value="0" <?php if($smtp): ?><?php echo e($smtp->status == 0  ? 'selected' : ''); ?><?php endif; ?>><?php echo e(__('Label.No')); ?></option>
                                            <option value="1" <?php if($smtp): ?><?php echo e($smtp->status == 1  ? 'selected' : ''); ?><?php endif; ?>><?php echo e(__('Label.Yes')); ?></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label><?php echo e(__('Label.Host')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="host" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->host); ?><?php endif; ?>" placeholder="Enter Host">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label><?php echo e(__('Label.Port')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="port" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->port); ?><?php endif; ?>" placeholder="Enter Port">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label><?php echo e(__('Label.Protocol')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="protocol" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->protocol); ?><?php endif; ?>" placeholder="Enter Protocol">
                                    </div>
                                </div>
                                <div class="form-row">
                                    <div class="form-group col-md-3">
                                        <label><?php echo e(__('Label.User name')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="user" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->user); ?><?php endif; ?>" placeholder="Enter User Name">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label><?php echo e(__('Label.Password')); ?><span class="text-danger">*</span></label>
                                        <input type="password" name="pass" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->pass); ?><?php endif; ?>" placeholder="Enter Password">
                                        <label class="mt-1 text-gray">Search for better result <a href="https://support.google.com/mail/answer/185833?hl=en" target="_blank" class="btn-link">Click Here</a></label>
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label><?php echo e(__('Label.From name')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="from_name" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->from_name); ?><?php endif; ?>" placeholder="Enter From Name">
                                    </div>
                                    <div class="form-group col-md-3">
                                        <label><?php echo e(__('Label.From Email')); ?><span class="text-danger">*</span></label>
                                        <input type="text" name="from_email" class="form-control" value="<?php if($smtp): ?><?php echo e($smtp->from_email); ?><?php endif; ?>" placeholder="Enter From Email">
                                    </div>
                                </div>
                                <div class="border-top pt-3 text-right">
                                    <button type="button" class="btn btn-default mw-120" onclick="smtp_setting()"><?php echo e(__('Label.SAVE')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
    <script>

        // Sidebar Scroll Down
        let sidebarHeight = $('.sidebar')[0].scrollHeight;
        sidebar_down(sidebarHeight);

        function Function_Api_path() {
            /* Get the text field */
            var copyText = document.getElementById("api_path");

            /* Select the text field */
            copyText.select();
            copyText.setSelectionRange(0, 99999); /* For mobile devices */

            document.execCommand('copy');

            /* Alert the copied text */
            alert("Copied the API Path: " + copyText.value);
        }

        function app_setting() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                var formData = new FormData($("#app_setting")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("setting.app")); ?>',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'app_setting', '<?php echo e(route("setting")); ?>');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('You have no right to add, edit, and delete.');
            }
        }
        function save_currency() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                var formData = new FormData($("#save_currency")[0]);
                $("#dvloader").show();
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("setting.currency")); ?>',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        $("html, body").animate({scrollTop: 0}, "swing");
                        get_responce_message(resp);
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('You have no right to add, edit, and delete.');
            }
        }
        function smtp_setting() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var formData = new FormData($("#smtp_setting")[0]);
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("smtp.save")); ?>',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        $("html, body").animate({scrollTop: 0}, "swing");
                        get_responce_message(resp);
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('You have no right to add, edit, and delete.');
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtpocket_fm/resources/views/admin/setting/index.blade.php ENDPATH**/ ?>