
<?php $__env->startSection('page_title',  'Profile'); ?>

<?php $__env->startSection('content'); ?>
	<?php echo $__env->make('admin.layout.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

	<div class="right-content">
		<?php echo $__env->make('admin.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm">Profile</h1>

			<div class="border-bottom row mb-3">
				<div class="col-sm-12">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Label.Dashboard')); ?></a></li>
						<li class="breadcrumb-item active" aria-current="page">Profile</li>
					</ol>
				</div>
			</div>

            <!-- Profile Info -->
            <div class="card custom-border-card">
                <form id="profile" enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="id" value="<?php if($data): ?><?php echo e($data->id); ?><?php endif; ?>">
                    <h5 class="card-header">Personal Info</h5>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>User Name<span class="text-danger">*</span></label>
                                    <input type="text" name="user_name" value="<?php if($data): ?><?php echo e($data->user_name); ?><?php endif; ?>" class="form-control" placeholder="Enter User Name" autofocus>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Email<span class="text-danger">*</span></label>
                                    <input type="text" name="email" value="<?php if($data): ?><?php echo e($data->email); ?><?php endif; ?>" class="form-control" placeholder="Enter Email">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="border-top pt-3 text-right">
                        <button type="button" class="btn btn-default mw-120" onclick="update_profile()"><?php echo e(__('Label.UPDATE')); ?></button>
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                    </div>
                </form>
            </div>

            <!-- Change Password  -->
            <div class="card custom-border-card">
                <form id="change_password" enctype="multipart/form-data" autocomplete="off">
                    <input type="hidden" name="id" value="<?php if($data): ?><?php echo e($data->id); ?><?php endif; ?>">
                    <h5 class="card-header"><?php echo e(__('Label.Change Password')); ?></h5>
                    <div class="card-body">
                        <div class="form-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Current Password<span class="text-danger">*</span></label>
                                    <input type="password" name="current_password" class="form-control" placeholder="Enter Current Password">
                                </div>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo e(__('Label.New Password')); ?><span class="text-danger">*</span></label>
                                    <input type="password" name="new_password" class="form-control" placeholder="Enter New Password">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo e(__('Label.Confirm Password')); ?><span class="text-danger">*</span></label>
                                    <input type="password" name="confirm_password" class="form-control" placeholder="Enter Confirm Password">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="border-top pt-3 text-right">
                        <button type="button" class="btn btn-default mw-120" onclick="update_password()"><?php echo e(__('Label.UPDATE')); ?></button>
                        <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>">
                    </div>
                </form>
            </div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('pagescript'); ?>
	<script>
		function update_profile(){
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var formData = new FormData($("#profile")[0]);

                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("profile.store")); ?>',
                    data: formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    success:function(resp){
                        $("#dvloader").hide();
                        get_responce_message(resp, 'profile', '<?php echo e(route("profile.index")); ?>');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('You have no right to add, edit, and delete.');
            }
		}
        function update_password() {
            var Check_Admin = '<?php echo Check_Admin_Access(); ?>';
            if(Check_Admin == 1){

                $("#dvloader").show();
                var formData = new FormData($("#change_password")[0]);

                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("profile.changepassword")); ?>',
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function(resp) {
                        $("#dvloader").hide();
                        get_responce_message(resp, 'change_password', '<?php echo e(route("profile.index")); ?>');
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                toastr.error('You have no right to add, edit, and delete.');
            }
        }
	</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.page-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/envato/app/dtpocket_fm/resources/views/admin/profile/index.blade.php ENDPATH**/ ?>